<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreStateRequest;
use App\Http\Requests\UpdateStateRequest;
use App\Models\Country;
use App\Models\State;

class StateController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Country $country)
    {
        $states = $country->states()->withCount('cities')
            ->orderBy('name')
            ->get();

        return view('admin.location.state.index', compact('states', 'country'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Country $country)
    {
        $state = new State;
        $countries = Country::orderBy('name')->select('id', 'name')->get();

        return view('admin.location.state.create', compact('state', 'countries', 'country'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreStateRequest $request, Country $country)
    {
        $data = $request->validated();
        $data['status'] = $request->has('status');

        try {
            State::create($data);

            return redirect()->route('admin.location.state.index', $country->id)->with('success', 'State created successfully.');
        } catch (\Exception $e) {
            // return $e->getMessage();
            return redirect()->back()->with('error', 'State could not be created.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(State $state, Country $country)
    {
        abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Country $country, State $state)
    {
        $countries = Country::orderBy('name')->select('id', 'name')->get();

        return view('admin.location.state.create', compact('state', 'countries', 'country'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateStateRequest $request, Country $country, State $state)
    {
        $data = $request->validated();

        $data['status'] = $request->has('status');
        if ($request->has('flag')) {
            $data['flag'] = $request->file('flag')->store('countries', 'public');
        }

        try {
            $state->update($data);

            return redirect()->route('admin.location.state.index', $country->id)->with('success', 'State updated successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'State could not be updated.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Country $country, State $state)
    {
        try {
            $state->delete();
            $state->cities()->delete();

            return response()->json(['message' => 'State deleted successfully.', 'status' => 'success']);
        } catch (\Exception $e) {
            return response()->json(['message' => 'State could not be deleted.', 'status' => 'error'], 500);
        }
    }
}
